/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.linker;

import filenet.vw.apps.linker.VWLinkerConstants;
import filenet.vw.apps.linker.VWLinkerLaunchPropertyDialog;
import filenet.vw.apps.linker.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.IVWIDMDialog;
import filenet.vw.idm.toolkit.IVWIDMDocClass;
import filenet.vw.idm.toolkit.IVWIDMDocument;
import filenet.vw.idm.toolkit.IVWIDMItem;
import filenet.vw.idm.toolkit.IVWIDMLibrary;
import filenet.vw.idm.toolkit.IVWIDMLink;
import filenet.vw.idm.toolkit.IVWIDMPropertyDescription;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class VWLinkerWFPropertyDialog
extends VWModalDialog
implements ActionListener {
    protected JRadioButton m_docClassRadioButton = null;
    protected JComboBox m_docClassComboBox = null;
    protected JRadioButton m_documentRadioButton = null;
    protected JTextField m_doccumentTextField = new JTextField();
    protected JTextField m_linkNameTextField = new JTextField();
    protected JLabel m_wfTitleLabel = new JLabel();
    protected JLabel m_wfVersionLabel = new JLabel();
    protected JComboBox m_wfVersionComboBox = new JComboBox();
    protected JTextField m_wfSubjectTextField = new JTextField();
    protected JComboBox m_launchTypeComboBox = null;
    protected String m_launchCondition = null;
    protected JButton m_OKButton = new JButton(VWResource.OK);
    protected JButton m_cancelButton = new JButton(VWResource.Cancel);
    protected JButton m_helpButton = new JButton(VWResource.Help);
    protected JButton m_browseButton = new JButton(VWResource.Browse);
    protected JButton m_conditionButton = new JButton(VWResource.Condition);
    protected boolean m_frameSizeAdjusted = false;
    protected int m_retStatus = 1;
    protected Frame m_parentFrame = null;
    protected int m_linkType;
    protected boolean m_bNewLink = false;
    protected IVWIDMDocument m_wfDefinition = null;
    protected IVWIDMLibrary m_library = null;
    protected IVWIDMDocClass[] m_docClassList = null;
    protected IVWIDMDocument m_document = null;
    protected IVWIDMLink m_link = null;
    protected IVWIDMPropertyDescription[] m_propertyList = null;

    public VWLinkerWFPropertyDialog(Frame parent) {
        super(parent);
        this.m_parentFrame = parent;
    }

    public void init(IVWIDMLibrary lib, IVWIDMDocument wfDefinition) {
        try {
            this.m_bNewLink = true;
            this.m_wfDefinition = wfDefinition;
            this.m_library = lib;
            this.m_docClassList = this.m_library.docClasses();
            this.m_wfTitleLabel.setText(this.m_wfDefinition.getLabel());
            this.m_wfVersionLabel.setText(this.m_wfDefinition.getVersionNumber());
            this.setupWfVersion(this.m_wfDefinition, null);
            this.m_linkType = 2;
            this.m_launchTypeComboBox = new JComboBox<String>(VWLinkerConstants.DOC_LAUNCH_TYPES);
            this.setTitle(VWResource.eProcessLinkProperty);
            Dimension dim = VWStringUtils.stringToDimension(VWResource.WFLinkPropertyDialogDim);
            if (dim == null) {
                dim = new Dimension(500, 300);
            }
            this.setSize(dim);
            this.setVisible(false);
            this.getContentPane().setLayout(new BorderLayout(10, 10));
            this.getContentPane().add((Component)this.createMiddlePanel(true), "Center");
            this.getContentPane().add((Component)this.createButtonPanel(), "Last");
            this.setLocationRelativeTo(this.m_parentFrame);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void init(IVWIDMLibrary lib, IVWIDMDocument wfDefinition, IVWIDMLink link) {
        try {
            this.m_bNewLink = false;
            this.m_wfDefinition = wfDefinition;
            this.m_library = lib;
            this.m_docClassList = this.m_library.docClasses();
            this.m_propertyList = link.getAssociatedPropertyDescriptions();
            if (link.getLinkType() == 0) {
                this.m_linkType = 1;
                this.m_launchTypeComboBox = new JComboBox<String>(VWLinkerConstants.DOCCLASS_LAUNCH_TYPES);
            } else {
                this.m_linkType = 2;
                this.m_launchTypeComboBox = new JComboBox<String>(VWLinkerConstants.DOC_LAUNCH_TYPES);
            }
            this.m_launchTypeComboBox.setSelectedItem(VWResource.Manual);
            this.m_link = link;
            this.m_wfTitleLabel.setText(this.m_wfDefinition.getLabel());
            this.setupWfVersion(this.m_wfDefinition, link);
            this.m_linkNameTextField.setText(this.m_link.getName());
            this.m_wfSubjectTextField.setText(this.m_link.getSubject());
            this.m_launchCondition = this.m_link.getExpression();
            switch (this.m_link.getEventType()) {
                case 0: {
                    this.m_launchTypeComboBox.setSelectedItem(VWResource.Manual);
                    break;
                }
                case 2: {
                    this.m_launchTypeComboBox.setSelectedItem(VWResource.OnAdd);
                    break;
                }
                case 1: {
                    this.m_launchTypeComboBox.setSelectedItem(VWResource.OnCheckin);
                }
            }
            this.setTitle(VWResource.eProcessLinkProperty);
            Dimension dim = VWStringUtils.stringToDimension(VWResource.WFLinkPropertyDialogDim);
            if (dim == null) {
                dim = new Dimension(500, 300);
            }
            this.setSize(dim);
            this.setVisible(false);
            this.getContentPane().setLayout(new BorderLayout(10, 10));
            this.getContentPane().add((Component)this.createMiddlePanel(false), "Center");
            this.getContentPane().add((Component)this.createButtonPanel(), "Last");
            this.setLocationRelativeTo(this.m_parentFrame);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void setupWfVersion(IVWIDMDocument wfDefDoc, IVWIDMLink link) {
        try {
            String wfDefId = wfDefDoc.getIdWithVer();
            int iX = wfDefId.lastIndexOf(58);
            this.m_wfVersionComboBox.removeAllItems();
            IVWIDMItem[] verList = wfDefDoc.list(false);
            for (int i = 0; i < verList.length; ++i) {
                String docId = verList[i].getId();
                iX = docId.lastIndexOf(58);
                this.m_wfVersionComboBox.addItem(docId.substring(iX + 1));
            }
            if (link == null) {
                this.m_wfVersionComboBox.setSelectedItem(wfDefId.substring(iX + 1));
            } else {
                String docId = link.getWflDocID();
                iX = docId.lastIndexOf(58);
                this.m_wfVersionComboBox.setSelectedItem(docId.substring(iX + 1));
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected JPanel createMiddlePanel(boolean bAddNew) {
        JPanel mainPanel = null;
        try {
            JLabel docNameLabel;
            mainPanel = new JPanel();
            mainPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbConst = new GridBagConstraints();
            gbConst.fill = 2;
            gbConst.anchor = 23;
            gbConst.gridwidth = 1;
            gbConst.gridheight = 1;
            gbConst.insets = new Insets(4, 10, 4, 10);
            int rowId = 0;
            gbConst.gridx = 0;
            gbConst.gridy = 0;
            gbConst.gridwidth = 1;
            gbConst.weightx = 0.0;
            JLabel workflowTitleLabel = new JLabel(VWResource.s_label.toString(VWResource.WorkflowTitleLabel), 2);
            mainPanel.add((Component)workflowTitleLabel, gbConst);
            gbConst.gridx = 1;
            gbConst.gridwidth = 0;
            gbConst.weightx = 1.0;
            mainPanel.add((Component)this.m_wfTitleLabel, gbConst);
            gbConst.gridx = 0;
            ++rowId;
            gbConst.gridy = rowId++;
            gbConst.gridwidth = 1;
            gbConst.weightx = 0.0;
            JLabel workflowVersionLabel = new JLabel(VWResource.s_label.toString(VWResource.WorkflowVersionLabel), 2);
            mainPanel.add((Component)workflowVersionLabel, gbConst);
            gbConst.gridx = 1;
            gbConst.gridwidth = 1;
            mainPanel.add((Component)this.m_wfVersionComboBox, gbConst);
            gbConst.insets = new Insets(4, 4, 4, 4);
            gbConst.gridx = 0;
            gbConst.gridy = rowId++;
            gbConst.gridwidth = 0;
            gbConst.weightx = 1.0;
            mainPanel.add((Component)new JSeparator(), gbConst);
            gbConst.insets = new Insets(4, 10, 4, 10);
            if (bAddNew) {
                gbConst.gridx = 0;
                gbConst.gridy = rowId++;
                gbConst.gridwidth = 1;
                gbConst.weightx = 0.0;
                this.m_documentRadioButton = new JRadioButton(VWResource.s_label.toString(VWResource.Document));
                this.m_documentRadioButton.setSelected(true);
                mainPanel.add((Component)this.m_documentRadioButton, gbConst);
                this.m_documentRadioButton.addActionListener(this);
                gbConst.gridx = 1;
                gbConst.gridwidth = 2;
                gbConst.weightx = 1.0;
                this.m_doccumentTextField.setEnabled(false);
                this.m_doccumentTextField.setEditable(false);
                mainPanel.add((Component)this.m_doccumentTextField, gbConst);
                this.m_doccumentTextField.addActionListener(this);
                gbConst.gridx = 3;
                gbConst.gridwidth = 1;
                gbConst.weightx = 0.0;
                mainPanel.add((Component)this.m_browseButton, gbConst);
                this.m_browseButton.setEnabled(true);
                this.m_browseButton.addActionListener(this);
                gbConst.gridx = 0;
                gbConst.gridy = rowId;
                gbConst.weightx = 0.0;
                this.m_docClassRadioButton = new JRadioButton(VWResource.s_label.toString(VWResource.DocumentClass));
                this.m_docClassRadioButton.setSelected(false);
                mainPanel.add((Component)this.m_docClassRadioButton, gbConst);
                this.m_docClassRadioButton.addActionListener(this);
                gbConst.gridx = 1;
                gbConst.gridwidth = 2;
                gbConst.weightx = 1.0;
                this.m_docClassComboBox = new JComboBox<IVWIDMDocClass>(this.m_docClassList);
                this.m_docClassComboBox.setEnabled(false);
                mainPanel.add((Component)this.m_docClassComboBox, gbConst);
                this.m_docClassComboBox.addActionListener(this);
            } else if (this.m_linkType == 2) {
                gbConst.gridx = 0;
                gbConst.gridy = ++rowId;
                gbConst.gridwidth = 1;
                gbConst.weightx = 0.0;
                docNameLabel = new JLabel(VWResource.s_label.toString(VWResource.Document), 2);
                mainPanel.add((Component)docNameLabel, gbConst);
                gbConst.gridx = 1;
                gbConst.gridwidth = 2;
                gbConst.weightx = 1.0;
                IVWIDMDocument doc = this.m_library.getDocument(this.m_link.getDocumentId());
                mainPanel.add((Component)new JLabel(doc.getLabel()), gbConst);
            } else {
                gbConst.gridx = 0;
                gbConst.gridy = ++rowId;
                gbConst.gridwidth = 1;
                gbConst.weightx = 0.0;
                docNameLabel = new JLabel(VWResource.s_label.toString(VWResource.DocumentClass), 2);
                mainPanel.add((Component)docNameLabel, gbConst);
                gbConst.gridx = 1;
                gbConst.gridwidth = 2;
                gbConst.weightx = 1.0;
                mainPanel.add((Component)new JLabel(this.m_link.getDocumentClass()), gbConst);
            }
            gbConst.gridx = 0;
            ++rowId;
            gbConst.gridy = rowId++;
            gbConst.gridwidth = 1;
            gbConst.weightx = 0.0;
            JLabel linkNameLabel = new JLabel(VWResource.s_label.toString(VWResource.LinkNameLabel), 2);
            mainPanel.add((Component)linkNameLabel, gbConst);
            gbConst.gridx = 1;
            gbConst.gridwidth = 2;
            gbConst.weightx = 1.0;
            mainPanel.add((Component)this.m_linkNameTextField, gbConst);
            this.m_linkNameTextField.addActionListener(this);
            gbConst.gridx = 0;
            gbConst.gridy = rowId++;
            gbConst.gridwidth = 1;
            gbConst.weightx = 0.0;
            JLabel workfloSubjectLabel = new JLabel(VWResource.s_label.toString(VWResource.WorkflowSubjectLabel), 2);
            mainPanel.add((Component)workfloSubjectLabel, gbConst);
            gbConst.gridx = 1;
            gbConst.gridwidth = 2;
            gbConst.weightx = 1.0;
            mainPanel.add((Component)this.m_wfSubjectTextField, gbConst);
            this.m_wfSubjectTextField.addActionListener(this);
            gbConst.insets = new Insets(4, 4, 4, 4);
            gbConst.gridx = 0;
            gbConst.gridy = rowId++;
            gbConst.weightx = 1.0;
            gbConst.gridwidth = 0;
            mainPanel.add((Component)new JSeparator(), gbConst);
            gbConst.insets = new Insets(4, 10, 4, 10);
            gbConst.gridx = 0;
            gbConst.gridy = rowId;
            gbConst.weightx = 0.0;
            gbConst.gridwidth = 1;
            JLabel launchTypeLabel = new JLabel(VWResource.s_label.toString(VWResource.LaunchType), 2);
            mainPanel.add((Component)launchTypeLabel, gbConst);
            gbConst.gridx = 1;
            gbConst.weightx = 1.0;
            gbConst.gridwidth = 2;
            mainPanel.add((Component)this.m_launchTypeComboBox, gbConst);
            gbConst.gridx = 3;
            gbConst.weightx = 0.0;
            gbConst.gridwidth = 1;
            mainPanel.add((Component)this.m_conditionButton, gbConst);
            if (this.m_propertyList == null) {
                this.m_launchTypeComboBox.setEnabled(false);
                this.m_conditionButton.setEnabled(false);
            }
            this.m_conditionButton.addActionListener(this);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return mainPanel;
    }

    protected JPanel createButtonPanel() {
        JPanel mainPanel = null;
        GridBagConstraints gbConst = new GridBagConstraints();
        try {
            mainPanel = new JPanel();
            mainPanel.setLayout(new GridBagLayout());
            gbConst.fill = 2;
            gbConst.gridwidth = 2;
            gbConst.gridheight = 1;
            gbConst.insets = new Insets(10, 10, 10, 10);
            this.m_OKButton.setSelected(true);
            mainPanel.add((Component)this.m_OKButton, gbConst);
            this.m_cancelButton.setSelected(false);
            mainPanel.add((Component)this.m_cancelButton, gbConst);
            this.m_helpButton.setSelected(false);
            mainPanel.add((Component)this.m_helpButton, gbConst);
            this.getRootPane().setDefaultButton(this.m_OKButton);
            this.m_OKButton.addActionListener(this);
            this.m_cancelButton.addActionListener(this);
            this.m_helpButton.addActionListener(this);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return mainPanel;
    }

    public void addNotify() {
        Dimension size = this.getSize();
        super.addNotify();
        if (this.m_frameSizeAdjusted) {
            return;
        }
        this.m_frameSizeAdjusted = true;
        Insets insets = this.getInsets();
        this.setSize(insets.left + insets.right + size.width, insets.top + insets.bottom + size.height);
    }

    public void disableWFEditing() {
        this.m_wfVersionComboBox.setEnabled(false);
    }

    public void actionPerformed(ActionEvent event) {
        Object obj = event.getSource();
        if (obj == this.m_documentRadioButton) {
            this.performDocRadioButtonAction();
        } else if (obj == this.m_docClassRadioButton) {
            this.performDocClassRadioButtonAction();
        } else if (obj == this.m_docClassComboBox) {
            this.performDocClassComboBox();
        } else if (obj == this.m_browseButton) {
            this.browseDocument();
        } else if (obj == this.m_conditionButton) {
            this.performEditLaunchCondition();
        } else if (obj == this.m_cancelButton) {
            this.m_retStatus = 1;
            this.setVisible(false);
        } else if (obj == this.m_OKButton) {
            this.performOKButtonAction();
        } else if (obj == this.m_helpButton) {
            VWHelp.displayPage(VWHelp.Help_eProcess_Doc + "link/vwlinkerwfproperty.htm");
        }
    }

    public int getReturnStatus() {
        return this.m_retStatus;
    }

    public int getLinkType() {
        return this.m_linkType;
    }

    public String getLinkName() {
        return this.m_linkNameTextField.getText();
    }

    public String getWorkflowSubject() {
        return this.m_wfSubjectTextField.getText();
    }

    public IVWIDMDocClass getDocClass() {
        if (this.m_linkType == 1) {
            return (IVWIDMDocClass)this.m_docClassComboBox.getSelectedItem();
        }
        return null;
    }

    public IVWIDMDocument getDocument() {
        if (this.m_linkType == 2) {
            return this.m_document;
        }
        return null;
    }

    public String getWfDefDocId() {
        String docId = this.m_wfDefinition.getId();
        int iX = docId.lastIndexOf(58);
        if (iX < 0) {
            return docId + ":" + (String)this.m_wfVersionComboBox.getSelectedItem();
        }
        return docId.substring(0, iX) + ":" + (String)this.m_wfVersionComboBox.getSelectedItem();
    }

    public int getLaunchType() {
        int launchType = 0;
        String eventType = (String)this.m_launchTypeComboBox.getSelectedItem();
        if (VWStringUtils.compare(eventType, VWResource.OnAdd) == 0) {
            launchType = 2;
        } else if (VWStringUtils.compare(eventType, VWResource.OnCheckin) == 0) {
            launchType = 1;
        }
        return launchType;
    }

    public String getLaunchCondition() {
        return this.m_launchCondition;
    }

    private void performEditLaunchCondition() {
        try {
            VWLinkerLaunchPropertyDialog launchProperty = new VWLinkerLaunchPropertyDialog(this.m_parentFrame, this.m_propertyList, (String)this.m_launchTypeComboBox.getSelectedItem());
            launchProperty.setLaunchCondition(this.m_launchCondition);
            launchProperty.setVisible(true);
            if (launchProperty.getReturnStatus() == 0) {
                this.m_launchCondition = launchProperty.getLaunchCondition();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void browseDocument() {
        IVWIDMDocument chosenDoc = null;
        try {
            IVWIDMDialog browserDialog = VWIDMBaseFactory.instance().getBrowseDialog(chosenDoc, 17, null, this.m_library.getId());
            if (browserDialog.showDialog(this.m_parentFrame) == 0 && (chosenDoc = (IVWIDMDocument)browserDialog.getSelectedItem()) != null) {
                if (!chosenDoc.canCreateWorkflowLink()) {
                    JOptionPane.showMessageDialog(this, VWResource.CannotSelectDocument.toString(chosenDoc.getId()), VWResource.ErrorMessage, 0);
                } else {
                    this.m_doccumentTextField.setText(chosenDoc.getLabel());
                    this.m_document = chosenDoc;
                    this.m_propertyList = this.m_document.getDocClass().getPropertyDescriptions();
                    this.m_launchTypeComboBox.setEnabled(true);
                    this.m_conditionButton.setEnabled(true);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performDocRadioButtonAction() {
        try {
            this.m_docClassRadioButton.setSelected(false);
            this.m_docClassComboBox.setEnabled(false);
            this.m_doccumentTextField.setEnabled(false);
            this.m_browseButton.setEnabled(true);
            this.m_linkType = 2;
            this.m_launchTypeComboBox.removeAllItems();
            for (int i = 0; i < VWLinkerConstants.DOC_LAUNCH_TYPES.length; ++i) {
                this.m_launchTypeComboBox.addItem(VWLinkerConstants.DOC_LAUNCH_TYPES[i]);
            }
            this.m_propertyList = null;
            this.m_conditionButton.setEnabled(false);
            this.m_launchTypeComboBox.setEnabled(false);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performDocClassRadioButtonAction() {
        try {
            this.m_documentRadioButton.setSelected(false);
            this.m_doccumentTextField.setText("");
            this.m_document = null;
            this.m_propertyList = null;
            this.m_conditionButton.setEnabled(false);
            this.m_launchTypeComboBox.setEnabled(false);
            this.m_docClassComboBox.setEnabled(true);
            this.m_docClassComboBox.setSelectedIndex(0);
            this.m_doccumentTextField.setEnabled(false);
            this.m_doccumentTextField.setBackground(this.getBackground());
            this.m_browseButton.setEnabled(false);
            this.m_linkType = 1;
            this.m_launchTypeComboBox.removeAllItems();
            for (int i = 0; i < VWLinkerConstants.DOCCLASS_LAUNCH_TYPES.length; ++i) {
                this.m_launchTypeComboBox.addItem(VWLinkerConstants.DOCCLASS_LAUNCH_TYPES[i]);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performDocClassComboBox() {
        try {
            IVWIDMDocClass docClass = (IVWIDMDocClass)this.m_docClassComboBox.getSelectedItem();
            this.m_propertyList = docClass.getPropertyDescriptions();
            this.m_launchTypeComboBox.setEnabled(true);
            this.m_conditionButton.setEnabled(true);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performOKButtonAction() {
        try {
            String linkName;
            if (this.m_linkType == 2 && this.m_bNewLink) {
                if (this.m_document == null) {
                    JOptionPane.showMessageDialog(this, VWResource.DocumentIsNotSelected, null, 1, null);
                    return;
                }
                String docName = this.m_doccumentTextField.getText();
                if (this.m_doccumentTextField.isEditable() && (docName == null || docName.length() == 0)) {
                    JOptionPane.showMessageDialog(this, VWResource.NameCanNotBeNull, null, 1, null);
                    return;
                }
            }
            if ((linkName = this.m_linkNameTextField.getText()) == null || linkName.length() == 0) {
                JOptionPane.showMessageDialog(this, VWResource.LinkNameIsEmpty, null, 1, null);
                return;
            }
            String subject = this.m_wfSubjectTextField.getText();
            if (subject == null || subject.length() == 0) {
                JOptionPane.showMessageDialog(this, VWResource.SubjectCanNotBeNull, null, 1, null);
                return;
            }
            this.setVisible(false);
            this.m_retStatus = 0;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

